 /*
  * UAE - The Un*x Amiga Emulator
  *
  * Support for the OS2 DART sound system.
  *
  * Copyright 1997 Bernd Schmidt
  */

extern void                *sndptr;                    // pointer for the buffers
extern void                *sndptrmax;

void flush_sound_buffer(void);
void stop_sound(void);
void start_sound( void );


static __inline__ void check_sound_buffers (void)
{
}


#define PUT_SOUND_BYTE(b)                \
        if (sndptr == sndptrmax)         \
           flush_sound_buffer();         \
        *(char *)sndptr++ = b;

#define PUT_SOUND_WORD(b)                \
        if (sndptr == sndptrmax)         \
           flush_sound_buffer();         \
        *(short *)sndptr = b;            \
        sndptr += 2;

#define PUT_SOUND_BYTE_RIGHT(b) PUT_SOUND_BYTE(b)
#define PUT_SOUND_BYTE_LEFT(b)  PUT_SOUND_BYTE(b)
#define PUT_SOUND_WORD_RIGHT(b) PUT_SOUND_WORD(b)
#define PUT_SOUND_WORD_LEFT(b)  PUT_SOUND_WORD(b)

#define SOUND16_BASE_VAL 000
#define SOUND8_BASE_VAL  128

#define DEFAULT_SOUND_MINB 1024
#define DEFAULT_SOUND_MAXB 1024*32
#define DEFAULT_SOUND_BITS 16
#define DEFAULT_SOUND_FREQ 44100

#define HAVE_STEREO_SUPPORT

